/************************************************************************\
	Derived from the source for the GNU uuencode and uudecode utilities.
	Copyright (C) 1996 Les R. Titze

	Base64TxAsync ( binaryData, binSize, binOff, txFunc );

	local myTxFunc := func ( outData, newOff )
		begin
		_v_OutStrBuff := outData;
		:TxOutBuff();
		return true;	// "keepGoing" - nil = async return from UUEncTxAsync
		end;

\************************************************************************/

#include "objects.h"
#include "NewtonScript.h"

// ENC is the basic 1 character encoding function to make a char printing.
#define ENC(Char) (trans_ptr[(Char) & 0x3F])

static void _b64encodeStdTxAsync ( void * srcBinP, long binSize, long binOff, RefArg txFunc );

extern "C" Ref Base64TxAsync ( RefArg rcvr, RefArg binObj, RefArg binSize, RefArg binOff, RefArg txFunc )
{
	long sz = RefToInt ( binSize );
	long of = RefToInt ( binOff );

	WITH_LOCKED_BINARY ( binObj, srcP )

		_b64encodeStdTxAsync ( srcP, sz, of, txFunc );

	END_WITH_LOCKED_BINARY(binObj)

	return MakeBoolean ( 0 );
}


void _b64encodeStdTxAsync ( void * srcBinP, long binSize, long binOff, RefArg txFunc )
{
	const char trans_ptr[64] =		// referenced in "ENC" macro (above)
	{
	//       0   1   2   3   4   5   6   7
		'A','B','C','D','E','F','G','H', // 0
		'I','J','K','L','M','N','O','P', // 1
		'Q','R','S','T','U','V','W','X', // 2
		'Y','Z','a','b','c','d','e','f', // 3
		'g','h','i','j','k','l','m','n', // 4
		'o','p','q','r','s','t','u','v', // 5
		'w','x','y','z','0','1','2','3', // 6
		'4','5','6','7','8','9','+','/'  // 7
	};

	void	* srcFinirP = (void *)( (long)srcBinP + binSize );

	//short	outStr[100];
	char	outStr[100];

	//register short	* resultP;
	register char	* resultP;

	register char	* p;
	register long	ch;
	register unsigned long n;

	unsigned long srcOff = binOff;	// was 0 in non-async

	// LRT - 97/04/12 12:24 AM
	// perhaps this wasn't being set and we break before setting it!
	resultP = outStr;		// char out pointer

    /**
     * this class encodes 54 bytes per line. This results in a maximum
     * of 54/3 * 4 or 72 characters per output line, not counting the
     * line termination.
     */

	while(1)
	{
		void * startP = (void *)( (unsigned long)srcBinP + srcOff );
		void * finirP = (void *)( (unsigned long)startP + 54 );

		if ( finirP > srcFinirP )
			finirP = srcFinirP;

		n = (unsigned long)finirP - (unsigned long)startP;
		srcOff = srcOff + n;

		if ( n == 0 )		// done
			break;

		resultP = outStr;		// char out pointer

		// uuencode starts each line with encoded length
		// Base64 DOES NOT
		//*resultP++ = ENC ( n );

		for ( p = (char *)startP; n > 2; n -= 3, p += 3 )
		{
			*resultP++ = ENC ( *p >> 2 );

			*resultP++ = ENC ( ((*p << 4) & 0x30) | ((p[1] >> 4) & 0x0F ) );

			*resultP++ = ENC ( ((p[1] << 2) & 0x3C) | ((p[2] >> 6) & 0x03) );

			*resultP++ = ENC ( p[2] & 0x3F );
		}

		if ( n != 0 )
			break;

		*resultP++ = 13;	// <CR>
		*resultP++ = 10;	// <LF>
		*resultP++ = 0;		// end of string

		Ref keepGoing = 
			NSCall ( txFunc, MakeString ( outStr ), MakeInt ( srcOff ) );
			//NSCall ( txFunc, MakeString ( (UniChar *)outStr ), MakeInt ( srcOff ) );

		if ( ISNIL ( keepGoing ) )
		{
			return;
		}

		resultP = outStr;		// reset the char out pointer
	}

	if ( n != 0 )
	{
		char c1 = *p;
		char c2 = n == 1 ? 0 : p[1];

		*resultP++ = ENC ( c1 >> 2 );

		*resultP++ = ENC ( ((c1 << 4) & 0x30) | ((c2 >> 4) & 0x0F) );

		if (n == 1)
			// uuEncode pads with "`"
			//ch = ENC ('\0');
			// Base64 pads with '='
			ch = '=';
		else
		{
			ch = (c2 << 2) & 0x3C;
			ch = ENC (ch);
		}
		*resultP++ = ch;

		// uuEncode pads with "`"
		//ch = ENC ('\0');
		// Base64 pads with '='
		*resultP++ = '=';

		*resultP++ = 13;	// <CR>
		*resultP++ = 10;	// <LF>
	}

	// uuencode terminates the encoded text with a
	// final single line with just a "zero" length byte
	// Base64 does not.
	/***********************
	*resultP++ = ENC ( '\0' );

	*resultP++ = 13;	// <CR>
	*resultP++ = 10;	// <LF>
	*******************************/

	*resultP++ = 0;		// end of string

	// for this final one, we can ignore the return value from Newtonscript
	Ref keepGoing = 
		NSCall ( txFunc, MakeString ( outStr ), MakeInt ( -1 ) );
	//NSCall ( txFunc, MakeString ( (UniChar *)outStr ), MakeInt ( -1 ) );
}
